/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.util.List;
import javax.swing.JOptionPane;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.DataSourceEditorPanelUtil;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.DataSourceRegistry;
import org.das2.components.DasProgressPanel;
import org.das2.util.monitor.ProgressMonitor;

public class TestFindDiscoveryDataSources {
    public static void main(String[] args) {
        DataSourceFormat s;
        DataSourceRegistry registry = DataSourceRegistry.getInstance();
        registry.discoverFactories();
        registry.discoverRegistryEntries();
        System.err.println("== Autoplot can format to ==");
        List exts = registry.getFormatterExtensions();
        for (String ext : exts) {
            s = DataSourceRegistry.getInstance().getFormatByExt(ext);
            System.err.printf("%s: %s\n", ext, s);
        }
        System.err.println("== Autoplot can read ==");
        exts = registry.getSourceExtensions();
        for (String ext : exts) {
            s = DataSourceRegistry.getInstance().getSource(ext);
            System.err.printf("%s: %s\n", ext, s);
        }
        System.err.println("== Autoplot can discover ==");
        exts = registry.getSourceEditorExtensions();
        for (String ext : exts) {
            String uri = "vap+" + ext.substring(1) + ":";
            try {
                DataSourceEditorPanel p = DataSourceEditorPanelUtil.getEditorByExt((String)ext);
                if (p.reject(uri)) {
                    System.err.printf("           (nope) %s: %s\n", ext, p);
                    continue;
                }
                System.err.printf("%s: %s\n", ext, p);
                p.prepare(uri, null, (ProgressMonitor)DasProgressPanel.createFramed((String)("entering " + ext)));
                p.setURI(uri);
                JOptionPane.showMessageDialog(null, p.getPanel());
            }
            catch (Exception ex) {
                System.err.printf("           (exception) %s  %s\n", ext, ex);
            }
        }
    }
}

